
----------------------------------------------------------------------------------------------------------------
-- Default Key Combo Bindings
-- (c) 2006 Relic Entertainment


-- These combos should NOT be changed by the user.
-- They are here in case the user screws up the key bindings file in Root/KeyBindings/

-- Bindings use format "Control+Shift+A"

-- Valid keys
	--  a - Z   0 - 9
	-- Backspace Tab Enter Escape Space Apostrophe Comma
	-- Minus Period Slash Semicolon Equal LBracket Backslash RBracket Grave 
	-- Up Down Left Right Control Shift Alt CapsLock NumLock ScrollLock 
	-- Insert Delete Home End PageUp PageDown F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12 PrintScreen Pause 
	-- MouseLeft MouseRight MouseMiddle MouseTop xgcneaek MouseBottom 
	-- ScreenLeft ScreenRight ScreenTop ScreenBottom 
	-- Numpad0 Numpad1 Numpad2 Numpad3 Numpad4 Numpad5 Numpad6 
	-- Numpad7 Numpad8 Numpad9 NumpadMultiply NumpadPlus NumpadSeparator 
	-- NumpadMinus NumpadPeriod NumpadSlash 
	
bindings =
{

	----------------------------------------------------------------------------------------------------------------
	-- cope's commands
	----------------------------------------------------------------------------------------------------------------

	key_q 							="Q",
	key_w 							="W",
	key_e 							="E",
	key_r 							="R",
	key_t 							="T",
	key_z 							="Z",
	key_u							="U",
	

	----------------------------------------------------------------------------------------------------------------
	-- system commands
	----------------------------------------------------------------------------------------------------------------
	escape							="Escape",
	accept							="Enter",
	commandqueue						="Shift",
	pause							="Pause",
	systemmenu						="F10",
	

	
	----------------------------------------------------------------------------------------------------------------
	-- Universal taskbar commands (any hotkeys used here cannot be used elsewhere)
	----------------------------------------------------------------------------------------------------------------
	
	infantry_cycle						="Period",-- HOOKUP PLZ
	vehicle_cycle						="Slash", -- HOOKUP PLZ
	event_cue_cycle						="Space",
	
	-------------------------------------------
	-- Global Commands
	-------------------------------------------

	attack							="S",
	retreat							="H",
	repair							="M",
	reinforce						="A",		-- Never used in SP as a command
	attackground					="G",
	attackmelee						="F",
	halt							="D",
	rally							="F7",		-- Never used in SP as a command
	unload							="J",		-- Never used in SP as a command
	ping							="F8",		-- Never used in SP as a command
	defend							="F9",		-- Never used in SP as a command


	cancel_construction				="Escape",
	retire							="Delete",





	--------------------------------------------------------------------------------------------------------------	
	-- multiple selection hotkeys
	--------------------------------------------------------------------------------------------------------------
	select_all						="Control+A",
	select_hq                       ="F1",
	select_hero                     ="Period",
	retreat_hero					="Shift+X",
	retreat_all						="Alt+X",
	next_primary_selection  					="Tab",
	prev_primary_selection  					="Control+Tab",
	-- checked with mouse click (removes clicked items from selection) 
	-- note: must only be one key
	remove_selection_modifier  					="Control",		
	-- checked with mouse click (selects all units of the same type) -- note: must only be one key
	crop_selection_modifier 					="Shift",  --HOOKUP PLZZZZZZZZZZZZZ	
	
	--------------------------------------------------------------------------------------------------------------
	-- hotkey group hotkeys
	--------------------------------------------------------------------------------------------------------------
	-- Select the group #
	
	hkgroup_select0						="0",
	hkgroup_select1						="1",
	hkgroup_select2						="2",
	hkgroup_select3						="3",
	hkgroup_select4						="4",
	hkgroup_select5						="5",
	hkgroup_select6						="6",
	hkgroup_select7						="7",
	hkgroup_select8						="8",
	hkgroup_select9						="9",

	-- Set the group to be the current selection
	
	hkgroup_set0						="Control+0",
	hkgroup_set1						="Control+1",
	hkgroup_set2						="Control+2",
	hkgroup_set3						="Control+3",
	hkgroup_set4						="Control+4",
	hkgroup_set5						="Control+5",
	hkgroup_set6						="Control+6",
	hkgroup_set7						="Control+7",
	hkgroup_set8						="Control+8",
	hkgroup_set9						="Control+9",
	
	-- Set the shift select groups
	
	hkgroup_shiftselect0				="Shift+0",
	hkgroup_shiftselect1				="Shift+1",
	hkgroup_shiftselect2				="Shift+2",
	hkgroup_shiftselect3				="Shift+3",
	hkgroup_shiftselect4				="Shift+4",
	hkgroup_shiftselect5				="Shift+5",
	hkgroup_shiftselect6				="Shift+6",
	hkgroup_shiftselect7				="Shift+7",
	hkgroup_shiftselect8				="Shift+8",
	hkgroup_shiftselect9				="Shift+9",


-------ALL UNIT/UPGRADE ---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------
	-------------------------------------------
	-------------- Space Marines Unit Creation--------------
	-------------------------------------------

	sm_scout_marine 			="C",
	sm_tactical_marine			="S",
	sm_devastator				="B",
	sm_assault_marine			="A",
	sm_devastator_plasma_cannon		="P",
	sm_dreadnought				="D",
	sm_rhino				="R",
	sm_predator				="T",
	tier_2					="U",
	tier_3					="U",



	-------------------------------------------
	-------------- Space Marine Global Abilities-------------
	-------------------------------------------
---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------

	sm_for_the_emperor		="F2",
	sm_larramans_blessing		="F2",
	sm_blessing_of_the_omnissiah	="F2",
	sm_call_drop_pod_dreadnought	="F4",
	sm_call_drop_pod_reinforce_pvp	="F3",
	sm_deep_strike_terminators	="F5",
	sm_deep_strike_terminators_assault	="F4",
	sm_apothecary_angels_of_death	="F4",
	sm_orbital_bombardment_pvp	="F6",

	
	-------------------------------------------
	-------------- Space Marine Unit Upgrades-------------
	-------------------------------------------
---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------

	sm_scout_squad_sergeant		="L",
	sm_shotgun			="T",
	sm_sniper_rifle			="N",
	sm_tactical_squad_sergeant	="L",
	sm_flamer			="F",
	sm_plasma_gun			="P",
	sm_missile_launcher		="M",
	heavy_bolter_rounds		="T",
	sm_assault_squad_sergeant	="L",
	melta_bombs			="B",
	sm_assault_cannon_dreadnought	="C",
	dark_age_of_technology		="D",
	rhino_armor			="P",
	sm_assault_cannon		="C",
	sm_heavy_flamer			="F",
	sm_cyclone_missile_launcher	="M",

	-------------------------------------------
	-------------- Space Marine Hero Upgrades-------------
	-------------------------------------------

	wp_force_two_handed_hammer	="H",
	wp_force_power_sword		="W",
	wp_force_sword_and_storm_shield	="D",
	wp_force_power_fist		="F",
	wp_force_assault_cannon		="C",
	wp_force_heavy_flamer		="F",
	arm_force_artificer_armour	="O",
	arm_force_pneumatically_enhanced_armour	="T",
	arm_force_terminator_armour	="M",
	acc_force_iron_halo		="I",
	acc_force_sacred_standard	="C",
	acc_force_teleporter_pack	="J",
	wp_apoth_anointed_power_axe	="N",
	wp_apoth_sanguine_chainsword	="W",
	wp_apoth_master_crafted_bolter	="F",
	arm_apoth_gyro_stabilized_armour="I",
	arm_apoth_combat_stimulant_equipment	="C",
	arm_apoth_armour_of_the_apothecarion	="H",
	acc_apoth_toxin_grenades	="G",
	acc_apoth_improved_medical_equipment	="M",
	acc_apoth_purification_rites	="P",
	arm_tech_signum_armor		="K",
	arm_tech_artificer_armour	="M",
	wp_tech_plasma_gun		="G",
	wp_tech_master_crafted_bolter	="T",
	wp_tech_consecrated_bolter	="B",
	arm_tech_bionics		="W",
	acc_tech_orbs_of_omnissiah	="O",
	acc_tech_refractor_field	="F",
	

	-------------------------------------------
	-------------- Space Marine unit abilities-------------
	-------------------------------------------
	
	sm_and_they_shall_know_no_fear	="T",
	sm_charge_dreadnaught		="C",
	sm_cyclone_missile_launcher_barrage_pvp	="B",
	sm_dreadnought_emperors_fist	="F",
	sm_focused_fire_pvp		="F",
	sm_frag_grenade			="F",
	sm_infiltration_pvp		="I",
	sm_let_it_burn			="N",
	sm_melta_bomb_pvp		="B",
	sm_merciless_blows		="C",
	sm_jump_assault_marine		="J",
	sm_flashbang			="I",
	sm_repair_pvp			="P",
	sm_dreadnought_charge		="C",
	sm_smoke_launcher		="M",
	sm_teleport_terminators		="J",
	sm_dreadnought_assault_cannon_barrage_explosive	="B",
		
	

	-------------------------------------------
	-------------- Space Marine hero abilities-------------
	-------------------------------------------

	sm_apothecary_advanced_healing	="H",
	sm_apothecary_heal		="E",
	sm_apothecary_heal_signum_armor	="E",
	sm_apothecary_rapid_fire	="F",
	sm_combat_stimulants		="C",
	sm_toxin_grenade_apothecary	="G",
	sm_battle_cry			="B", -- MP version
	sm_force_iron_halo		="I", -- MP version
	sm_defend			="D",
	sm_power_fist_tank_shock	="F",
	sm_sprint_pvp			="T",
	sm_teleport_apoth		="J",
	sm_brothers_in_arms		="B",
	sm_build_button			="B",
	sm_mark_target			="K",
	sm_powerful_sweep		="W",
	sm_refractor_field_blind	="D",
	sm_tech_refractor_field		="F",
	sm_techmarine_emp_grenade	="O",
	sm_techmarine_high_powered_shot	="T",
	sm_techmarine_overcharge	="G",
	
	------------------------------------
	-- SP Specific abilities
	------------------------------------
	
	-- Wargear abilities
	sm_melta_bomb								= "B", -- SP version
	sm_frag_grenade								= "F", -- SP version
	sm_frag_grenade_energy						= "F", -- SP version (upgraded version for Tarkus)
	sm_flash_grenade							= "I", -- SP version (actually called a blind grenade)
	sm_satchel_charge							= "D", -- SP version (demolition charge)
	sm_repair									= "P", -- SP version (matches MP)
	sm_medkit									= "M", -- SP version
	sm_cyclone_missile_launcher_barrage			= "B", -- SP version (matches MP)
	
	-- Stratagem abilities
	sm_call_bombing_run							= "C", -- SP version
	sm_blessing_of_fortitude					= "O", -- SP version
	sm_strat_supply_call_turret					= "V", -- SP version
	
	-- Unique FC abilities:
	sm_charge_force_commander					= "Q", -- Primary
	sm_str1_battle_cry							= "W", -- Secondary
	
	-- Unique FC Wargear
	sm_teleport_fc								= "E", -- Teleport Pack equipped
	sm_jump_fc									= "E", -- Jump Pack equipped
	sm_rally_banner								= "E", -- Rally Banner equipped
	sm_iron_halo								= "E", -- Iron Halo equipped
	sm_orbital_bombardment						= "R", -- Orbital Strike wargear equipped
	sm_call_drop_pod_reinforce					= "T", -- SP version
	
	-- Unique Tarkus abilities:
	sm_tactical_advance							= "Q", -- Primary
	sm_taunt_tarkus								= "W", -- Secondary
	
	-- Unique Cyrus abilities:
	sm_infiltrate								= "Q", -- Primary
	sm_suppressive_fire							= "W", -- Secondary
	sm_high_powered_shot						= "W", -- Secondary
	sm_high_explosive_shells					= "W", -- Secondary
	sm_promethium_bomb							= "W", -- Secondary
	sm_scout_reinforce							= "E", -- Tertiary
	
	-- Unique Cyrus Wargear
	sm_proximity_mines							= "R", -- Proximity Mines
	sm_remote_detonator							= "T", -- Remote Detonator
	
	-- Unique Avitus abilities:
	sm_focused_fire								= "Q", -- Primary
	sm_sprint									= "W", -- Secondary
	sm_clearout									= "E", -- Tertiary
	
	-- Unique Thaddeus abilities:
	sm_jump										= "Q", -- Primary
	sm_teleport									= "Q", -- Primary (variant with Terminator Armor equipped)
	sm_merciless_blows_thaddeus					= "W", -- Secondary
	
	-- Unique Thule abilities:
	sm_emperors_fist							= "Q", -- Primary
	sm_emperors_fist_improved					= "Q", -- Primary (upgraded version)
	sm_guardian									= "W", -- Secondary
	sm_charge_dreadnought						= "E", -- Tertiary
	sm_assault_cannon_barrage					= "R", -- Quad
	sm_assault_cannon_barrage_explosive			= "R", -- Quad
	
	-- Unique Gabriel abilities:
	sm_gabriel_inspiring_shout					= "Q", -- Primary
	sm_gabriel_marked_target					= "W", -- Secondary
	sm_gabriel_sunder_armor						= "E", -- Tertiary
	
	-- Defend global abilities
	sm_call_turret_defend						="F1",
	sm_call_proximity_mines_defend				="F2",
	sm_call_napalm								="F3",
	sm_call_orbital_bombardment_defend			="F4",
	
	-------------------------------------------
	-------------- Space Marine buildings-------------
	-------------------------------------------
	
	sm_heavy_bolter_turret_tech_marine	="U",
	sm_techmarine_field_ops			="Y",
	sm_deployable_cover			="O",
	sm_listening_post			="A",
	sm_generator				="A",
	sm_prox_mine_pvp			="M",


	-------------------------------------------
	-------------- Ork Unit Creation-------------
	-------------------------------------------
---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------

	ork_slugga			="S",
	ork_shoota			="H",
	ork_stikkbommas			="B",
	ork_stormboy			="R",
	ork_lootas			="L",
	ork_tankbustas			="T",
	ork_deff_dread			="D",
	ork_wartrukk			="W",
	ork_kommandos			="K",
	ork_tank			="O",
	ork_nob_squad			="N",

	-------------------------------------------
	-------------- Ork Global Abilities-------------
	-------------------------------------------
---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------

	ork_warboss_ard_boyz		="F3",
	ork_warboss_use_yer_choppas	="F4",
	ork_waaagh			="F2",
	ork_rokks			="F5",
	ork_kommando_kommandos_iz_da_sneakiest	="F4",
	ork_kommando_hide		="F3",
	ork_mekboy_more_dakka		="F3",
	ork_mekboy_kult_of_speed	="F4",
	

	-------------------------------------------
	-------------- Ork unit upgrades-------------
	-------------------------------------------
---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------

	ork_burna			="B",
	ork_nob_leader			="N",
	ork_big_shoota			="B",
	ork_nob_leader_shoota		="N",
	ork_stikkbomma_kit		="B",
	ork_stormboy_jump_upgrade	="K",
	ork_deffgun_beamy		="B",
	ork_tank_armor			="P",
	ork_nob_leader_kommando		="N",
	ork_nob_kit			="E",
	ork_nob_hammers			="H",
	ork_nob_leader_nobz		="N",
	ork_nob_leader_stormboy		="N",
	ork_deff_dread_burna		="B",


	-------------------------------------------
	-------------- Ork hero upgrades-------------
	-------------------------------------------
---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------

	wp1_mekboy_deffgun		="D",
	wp1_ork_mekboy_beamy_deffgun	="Y",
	arm_mekboy_electric_armor	="E",
	arm_mekboy_earthquake_machine	="G",
	arm_mekboy_battery_pack		="T",
	acc_mekboy_force_field		="F",
	acc_mekboy_prox_mines		="M",
	acc_mekboy_uber_generator	="B",
	wp1_ork_bang_bang_hammer	="H",
	wp1_ork_kustom_shoota		="M",
	wp1_ork_warboss_power_claw	="W",
	arm_ork_warboss_cybork_bits	="C",
	arm_warboss_spiky_armor		="I",
	arm_warboss_mega_armor		="O",
	acc_warboss_angry_bits		="Y",
	acc_warboss_boss_pole		="B",
	acc_warboss_trophy_rack		="K",
	wp1_kommando_spechul_shoota	="L",
	wp1_ork_kommando_hero_assassin_knife	="N",
	wp1_kommando_rokkit_launcha	="H",
	arm_kommando_extra_equipment	="E",
	arm_kommando_boom_time		="O",
	arm_kommando_camo_armor 	="C",
	acc_kommando_grenade		="T",
	acc_kommando_booby_trap		="P",
	acc_kommando_kaboom		="K",


	-------------------------------------------
	-------------- Ork unit abilities-------------
	-------------------------------------------
	
	ork_burna_bomb			="B",
	ork_deff_dread_rampage		="E",
	ork_infiltration		="I",
	ork_kommando_ambush		="D",
	ork_nob_frenzy			="E",
	ork_recklessness		="E",
	ork_smoke_bomb			="E",
	ork_steady_firing		="D",
	ork_stikkbomb_stikkbommas	="T",
	ork_stikkbomma_stun_grenade	="M",
	ork_stormboy_jump		="J",
	ork_stormboy_jump_improved	="J",
	ork_stormboy_suicide_bomba	="B",
	ork_tank_high_powered_shot	="B",
	ork_tankbusta_mortar_shots	="B",
	ork_waaagh_shout		="W",
	ork_repair			="P",
	



	-------------------------------------------
	-------------- Ork hero abilities-------------
	-------------------------------------------
	
	ork_assassinate_melee		="N",
	
	ork_infiltration_kommando	="I",
	ork_infiltration_kommando_improved	="I",
	ork_kommando_explosive_shells	="V",
	ork_kommando_kaboom		="K",
	ork_kommando_mark_target_shot	="H",
	ork_kommando_remote_detonation	="P",
	ork_kommando_stun_grenade	="B",
	ork_stikkbomb			="T",
	ork_mekboy_earthquake		="G",
	ork_mekboy_energy_transfer	="T",
	ork_force_field			="F",
	ork_mekboy_force_field_overcharge	="O",
	ork_mekboy_prox_mine_scatter	="M",
	ork_mekboy_teleport		="J",
	ork_mekboy_uber_shield		="B",
	ork_mekboy_electric_armor	="E",
	ork_warboss_big_stomp		="C",
	ork_warboss_stomp		="T",
	ork_warboss_now_im_angry	="Y",

	-------------------------------------------
	-------------- Ork buildings-------------
	-------------------------------------------
	
	ork_orky_turret_mek		="U",
	ork_waaagh_banner		="W",
	ork_listening_post		="A",
	ork_generator			="A",


	-------------------------------------------
	-------------- Eldar Unit Creation-------------
	-------------------------------------------
---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------

	eld_guardian			="G",
	eld_guardian_shuriken_cannon	="S",
	eld_ranger			="R",
	eld_banshee			="B",
	eld_warp_spider			="W",
	eld_guardian_brightlance	="L",
	eld_wraithlord			="D",
	eld_falcon			="F",
	eld_fire_prism			="P",
	eld_lesser_avatar		="A",
	eld_guardian_d_cannon		="C",



	-------------------------------------------
	-------------- Eldar Global Abilities-------------
	-------------------------------------------
---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------

	eld_webway_gate			="F2",
	eld_eldritch_storm		="F5",
	eld_farseer_farsight		="F3",
	eld_farseer_build_seer_council	="F4",
	eld_warlock_swift_movement	="F3",
	eld_warlock_conceal_global	="F4",
	eld_warp_spider_crack_shot	="F3",
	eld_warp_spider_spiders_brood	="F4",



	-------------------------------------------
	-------------- Eldar Unit Upgrades-------------
	-------------------------------------------
---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------	

	eld_warlock			="L",
	battle_equipment		="B",
	pathfinder_gear			="P",
	eld_banshee_exarch		="L",
	aspect_of_banshee		="C",
	eld_warpspider_exarch		="L",
	aspect_of_warp_spider		="C",
	wraithbone_synergy		="B",
	eld_shuriken_cannon_wl		="C",
	eld_brightlance			="L",
	falcon_holofield		="F",
	
	-------------------------------------------
	-------------- Eldar hero wargear-------------
	-------------------------------------------
---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------	

	wp_farse_witchblade_doombringer	="D",
	wp_farse_witchblade_singing_spear	="P",
	wp_farse_witchblade_sky_gauntlets	="V",
	arm_farse_rune_armour		="N",
	arm_farse_armour_of_fortune	="R",
	arm_farse_aegis_of_ages		="T",
	acc_farse_spirit_stones		="I",
	acc_farse_runes_of_reaping	="E",
	acc_farse_ghosthelm		="M",
	wp_warlock_witchblade_dimensional_blade	="E",
	wp_warlock_witchblade_enervator	="L",
	wp_warlock_witchblade_immolator	="I",
	arm_warlock_champions_robe	="P",
	arm_warlock_providence		="V",
	arm_warlock_cloak_of_shadows	="C",
	acc_warlock_force_gauntlets	="W",
	acc_warlock_channeling_runes	="N",
	acc_warlock_heart_of_darkness	="D",
	wp_heavy_gauge_filament		="V",
	wp_warp_entangling_web		="E",
	wp_warp_powerblades		="L",
	arm_warp_phase_armour		="P",
	arm_warp_improved_warp_generator="N",
	arm_warp_enhanced_warp_stabilizers	="I",
	acc_warp_improved_targeters	="T",
	acc_warp_shimmer_orb		="B",
	acc_warp_anti_grav_grenade	="G",



	-------------------------------------------
	-------------- Eldar Unit abilities-------------
	-------------------------------------------

	eld_avatar_wailing_doom		="D",
	eld_brightlance_focused_beam	="B",
	eld_d_cannon_black_hole		="B",
	eld_embolden			="E",
	eld_fire_prism_explosive_shot	="T",
	eld_fire_prism_focused_shot	="T",
	eld_fleet_of_foot		="F",
	eld_haywire_grenade		="G",
	eld_jump_warpspider		="J",
	eld_plasma_grenade		="G",
	eld_ranger_infiltration		="I",
	eld_suppressive_volley		="V",
	eld_war_shout			="W",
	eld_wraithlord_regenerate	="W",
	eld_holofield_falcon		="F",
	eld_holofield_ranger		="D",
	eld_avatar_khaines_wrath	="W",
	eld_repair			="P",

	
	
	

	-------------------------------------------
	-------------- Eldar hero abilities-------------
	-------------------------------------------

	eld_anti_grav_grenade		="G",
	eld_entangle			="E",
	eld_group_teleport		="U",
	eld_phase_shift			="P",
	eld_shimmer_orb			="B",
	eld_heavy_gauge_filament	="V",
	eld_warlock_channeling		="N",	
	eld_cloaking_shroud		="C",
	eld_destructor			="T",
	eld_warlock_ethereal_slash	="E",
	eld_force_pull			="W",
	eld_heart_of_darkness		="D",
	eld_immolate			="I",
	eld_providence			="V",
	eld_shield_projector		="P",
	eld_doom			="D",
	eld_fortune			="R",
	eld_guide			="G",
	eld_levitation_field		="V",
	eld_mind_war			="M",
	eld_spiritual_rites		="I",
	eld_time_field			="T",



	-------------------------------------------
	-------------- Eldar buildings-------------
	-------------------------------------------
	
	eld_energy_shield		="D",
	eld_generator			="A",
	eld_listening_post		="A",


	-------------------------------------------
	-------------- Tyranid Unit Creation-------------
	-------------------------------------------
---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------

	tyr_ripper			="R",
	tyr_hormagaunt			="H",
	tyr_termagaunt			="T",
	tyr_warrior			="W",
	tyr_spore_mines			="S",
	tyr_lictor			="L",
	tyr_ravener			="V",
	tyr_carnifex			="C",
	tyr_zoanthrope			="Z",
		
	-------------------------------------------
	-------------- Tyranid Global Abilities-------------
	-------------------------------------------
---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------

	tyr_spawning_pool		="F2",
	tyr_hive_tyrant_mycetic_spore_warriors	="F3",
	tyr_without_number		="F4",
	tyr_tyrannoformation		="F5",
	tyr_ravener_catalyst		="F2",
	tyr_ravener_drop_spore_mines	="F3",
	tyr_lictor_stalk		="F2",
	tyr_call_mycetic_spore_reinforce	="F3",
	
	-------------------------------------------
	-------------- Tyranid unit upgrades-------------
	-------------------------------------------
---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------

	tyr_venom_cannon_warrior 	="V",
	tyr_barbed_strangler_warrior	="B",
	tyr_warrior_adrenal_glands	="G",
	tyr_lictor_upgrade		="v",
	tyr_devourer			="D",
	tyr_bonded_exoskeleton		="T",
	tyr_barbed_strangler_carnifex	="B",
	tyr_venom_cannon_carnifex	="V",

	-------------------------------------------
	-------------- Tyranid hero upgrades-------------
	-------------------------------------------
---------ALL THESE HOTKEYS NEED TO BE HOOKED UP PLZ----------------

	wp_lictor_corrosive_claws	="V",
	wp_lictor_feeder_tendrils	="T",
	wp_lictor_scything_talons	="Y",
	wp_lictor_toxic_miasma		="N",
	tyr_arm_lictor_poison_cloud	="C",
	tyr_arm_lictor_energy_glands	="D",
	tyr_arm_lictor_elite_jump	="J",
	acc_lictor_loner		="L",
	acc_lictor_pheremone		="E",
	acc_lictor_retreat		="M",
	tyr_ravener_acid_splatter	="L",
	tyr_ravener_crippling_talon	="I",
	tyr_ravener_devourer_ap		="V",
	tyr_arm_ravener_regeneration_carapace	="H",
	tyr_arm_ravener_reflective_carapace	="N",
	tyr_arm_ravener_revive_carapace	="G",
	acc_ravener_burrow_trap		="P",
	acc_ravener_poison_cloud	="C",
	acc_ravener_synapse_aura_damage	="Y",
	acc_ravener_synapse_aura_speed	="W",
	wp_hive_heavy_claw		="W",
	wp_hive_knockback		="D",
	wp_hive_venom_cannon		="V",
	arm_hive_synapse_aura_health	="I",
	tyr_arm_hive_extended_carapace	="C",
	tyr_arm_hive_invulnerable	="E",
	acc_hive_psychic_shield		="F",
	acc_hive_bioplasma		="B",
	acc_hive_scream			="Y",


	-------------------------------------------
	-------------- Tyranid unit abilities-------------
	-------------------------------------------
	
	tyr_bioplasma_carnifex		="B",
	tyr_burrow_ravener		="B",
	tyr_charge_carnifex		="C",
	tyr_flesh_hook_lictor		="F",	
	tyr_infiltration		="I",
	tyr_psychic_shield_zoanthrope	="F",
	tyr_zoanthrope_focused_blast	="B",
	tyr_spawn_spore_mines		="C",
	tyr_spore_mine_detonate		="D",
	
	


	-------------------------------------------
	-------------- Tyranid hero abilities-------------
	-------------------------------------------

	tyr_ap_shots_ravener		="V",
	tyr_burrow_ravener_hero		="B",
	tyr_burrow_trap			="P",
	tyr_poison_cloud_ravener	="C",
	tyr_rapid_fire_ravener		="D",
	tyr_ravener_speed_boost		="F",
	tyr_ravener_tunnel		="T",
	tyr_bioplasma_armour		="B",
	tyr_charge_tyrant		="C",
	tyr_seismic_roar		="D",
	tyr_invulnerable_hive		="E",
	tyr_psychic_shield		="F",
	tyr_scream_hive			="Y",
	tyr_corrosion_lictor		="V",
	tyr_cripple_lictor		="N",
	tyr_elite_jump_lictor		="J",
	tyr_jump_lictor			="J",
	tyr_flesh_hook			="F",
	tyr_lictor_pheromone_attack	="E",
	tyr_poison_cloud_lictor		="C",
	tyr_retreat			="R",
	tyr_suppression_lictor		="Y",
	
	
	-------------------------------------------
	-------------- Tyranid buildings-------------
	-------------------------------------------

	tyr_generator			="A",
	tyr_listening_post		="A",
	
	

	
	
	
	






	
}